/* Simple app-shell service worker for LEFA PWA.
   Note: keep this intentionally small; production should add versioning + smarter caching. */

const CACHE = "lefa-v1";

const APP_SHELL = [
  "/",
  "/app",
  "/signin",
  "/offline",
  "/manifest.webmanifest",
  "/icons/icon-192.png",
  "/icons/icon-512.png",
];

self.addEventListener("install", (event) => {
  event.waitUntil(
    caches.open(CACHE).then((cache) => cache.addAll(APP_SHELL)).then(() => self.skipWaiting())
  );
});

self.addEventListener("activate", (event) => {
  event.waitUntil(
    caches.keys().then((keys) => Promise.all(keys.map((k) => (k === CACHE ? null : caches.delete(k))))).then(() => self.clients.claim())
  );
});

self.addEventListener("fetch", (event) => {
  const req = event.request;
  const url = new URL(req.url);

  // Only cache GET requests.
  if (req.method !== "GET") return;

  // Skip caching for API routes.
  if (url.pathname.startsWith("/api")) return;

  event.respondWith(
    caches.match(req).then((cached) => {
      if (cached) return cached;
      return fetch(req)
        .then((res) => {
          const copy = res.clone();
          caches.open(CACHE).then((cache) => cache.put(req, copy)).catch(() => {});
          return res;
        })
        .catch(async () => {
          // Offline fallback for navigation.
          if (req.mode === "navigate") return caches.match("/offline");
          throw new Error("offline");
        });
    })
  );
});
