import { prisma } from "@/lib/prisma";

export async function requireMerchant(userId: string) {
  const user = await prisma.user.findUnique({ where: { id: userId }, include: { merchant: true } });
  if (!user?.merchant) throw new Error("NOT_A_MERCHANT");
  return user;
}
