import { getServerSession } from "next-auth";
import { authOptions } from "@/lib/auth";

export async function requireRole(roles: Array<"CONSUMER" | "MERCHANT" | "ADMIN">) {
  const session = await getServerSession(authOptions);
  if (!session || !(session as any).uid) throw new Error("UNAUTHENTICATED");
  const role = (session as any).role as string;
  if (!roles.includes(role as any)) throw new Error("FORBIDDEN");
  return session as any;
}
