import type { ProviderAdapter, ProviderChargeRequest, ProviderPayoutRequest, ProviderResult } from "./types";
import { randomUUID } from "crypto";

function ok(provider: string): ProviderResult {
  return { provider, providerRef: `${provider}_${randomUUID()}`, status: "SUCCEEDED" };
}

export const MockProvider: ProviderAdapter = {
  name: "mock",
  async createCharge(_req: ProviderChargeRequest) {
    return ok("mock_charge");
  },
  async createPayout(_req: ProviderPayoutRequest) {
    return ok("mock_payout");
  },
  async getStatus(providerRef: string) {
    return { provider: "mock", providerRef, status: "SUCCEEDED" };
  },
};
