import { KycLevel, TxType } from "@prisma/client";

export type Limits = {
  perTxMinor: bigint;
  dailyOutMinor: bigint;
};

// Amounts are stored in "minor" (the codebase uses cents), so 100 = P1.00
export function limitsFor(level: KycLevel): Limits {
  switch (level) {
    case "FULL":
      return { perTxMinor: 10000n * 100n, dailyOutMinor: 50000n * 100n }; // P10k / P50k
    case "BASIC":
      return { perTxMinor: 2000n * 100n, dailyOutMinor: 10000n * 100n }; // P2k / P10k
    case "UNVERIFIED":
    default:
      return { perTxMinor: 500n * 100n, dailyOutMinor: 2000n * 100n }; // P500 / P2k
  }
}

export function isOutgoingType(t: TxType) {
  return t === "TRANSFER" || t === "PAYMENT" || t === "WITHDRAWAL";
}
