import bcrypt from "bcryptjs";
import crypto from "crypto";

export async function hashPassword(password: string): Promise<string> {
  const salt = await bcrypt.genSalt(12);
  return bcrypt.hash(password, salt);
}

export async function verifyPassword(password: string, hash: string): Promise<boolean> {
  return bcrypt.compare(password, hash);
}

export function randomToken(bytes = 32): string {
  return crypto.randomBytes(bytes).toString("hex");
}

export async function hashApiKey(apiKeyPlain: string): Promise<string> {
  const salt = await bcrypt.genSalt(12);
  return bcrypt.hash(apiKeyPlain, salt);
}

export async function verifyApiKey(apiKeyPlain: string, hash: string): Promise<boolean> {
  return bcrypt.compare(apiKeyPlain, hash);
}
