import { prisma } from "@/lib/prisma";
import { verifyApiKey } from "@/lib/crypto";

export async function authenticateApiKey(authHeader: string | null) {
  if (!authHeader) return null;
  const m = authHeader.match(/^Bearer\s+(.+)$/i);
  if (!m) return null;
  const plain = m[1].trim();
  if (!plain) return null;

  const keys = await prisma.apiKey.findMany({ where: { revokedAt: null } });
  for (const k of keys) {
    const ok = await verifyApiKey(plain, k.keyHash);
    if (ok) return k;
  }

  return null;
}
