"use client";

import Link from "next/link";
import { usePathname } from "next/navigation";
import clsx from "clsx";

export function TopNav() {
  const pathname = usePathname();

  const items = [
    { href: "/app", label: "Wallet" },
    { href: "/send", label: "Send" },
    { href: "/qr", label: "QR" },
    { href: "/app/kyc", label: "KYC" },
    { href: "/app/text-pay", label: "Text-to-Pay" },
    { href: "/app/disputes", label: "Disputes" },
    { href: "/merchant", label: "Merchant" },
    { href: "/merchant/pos", label: "POS" },
    { href: "/admin/settlement", label: "Settlement" },
  ];

  return (
    <div className="border-b border-zinc-200 bg-white">
      <div className="mx-auto flex max-w-5xl items-center justify-between px-4 py-3">
        <Link href="/app" className="text-sm font-semibold tracking-tight">
          LEFA
        </Link>
        <div className="flex items-center gap-2">
          {items.map((it) => (
            <Link
              key={it.href}
              href={it.href}
              className={clsx(
                "rounded-xl px-3 py-2 text-sm",
                pathname.startsWith(it.href)
                  ? "bg-zinc-900 text-white"
                  : "text-zinc-700 hover:bg-zinc-100"
              )}
            >
              {it.label}
            </Link>
          ))}
        </div>
      </div>
    </div>
  );
}
