import { TopNav } from "@/components/nav";
import { Card, CardBody, CardHeader, Container } from "@/components/ui";

export default function OfflinePage() {
  return (
    <>
      <TopNav />
      <Container>
        <div className="mx-auto max-w-xl">
          <Card>
            <CardHeader title="You are offline" subtitle="Some features need internet" />
            <CardBody>
              <div className="text-sm text-zinc-700">
                You can still open the app, view cached pages, and keep your pay links.
                Once you’re online again, payments and syncing will resume.
              </div>
              <div className="mt-3 text-xs text-zinc-500">
                Tip: If you’re in a taxi or market, ask the customer to connect briefly to pay.
              </div>
            </CardBody>
          </Card>
        </div>
      </Container>
    </>
  );
}
