"use client";

import { useFormState } from "react-dom";
import { createApiKeyAction, revokeApiKeyAction } from "@/app/actions/merchant";
import { Button, Input, Label } from "@/components/ui";

export function CreateKeyForm() {
  const [state, action] = useFormState(createApiKeyAction as any, null);

  return (
    <div className="rounded-xl border border-zinc-200 bg-zinc-50 p-4">
      <div className="text-sm font-medium">Create API key</div>
      <div className="mt-1 text-xs text-zinc-600">Shown once. Store it securely.</div>
      <form action={action} className="mt-3 flex items-end gap-3">
        <div className="flex-1">
          <Label>Name</Label>
          <Input name="name" placeholder="Online store" />
        </div>
        <Button type="submit">Create</Button>
      </form>
      {state?.ok === false ? <div className="mt-3 text-sm text-red-600">{state.error}</div> : null}
      {state?.ok ? (
        <div className="mt-3 rounded-xl border border-zinc-200 bg-white p-3">
          <div className="text-xs text-zinc-600">API key</div>
          <div className="mt-1 break-all font-mono text-sm">{state.apiKey}</div>
        </div>
      ) : null}
    </div>
  );
}

export function RevokeKeyButton({ id }: { id: string }) {
  const [state, action] = useFormState(revokeApiKeyAction as any, null);
  return (
    <form action={action}>
      <input type="hidden" name="id" value={id} />
      <Button type="submit" className="bg-red-600 hover:bg-red-500">
        {state?.ok ? "Revoked" : "Revoke"}
      </Button>
    </form>
  );
}
