import "@/styles/globals.css";
import { ReactNode } from "react";
import type { Metadata } from "next";
import { PwaRegister } from "@/components/pwa-register";

export const metadata: Metadata = {
  title: process.env.LEFA_APP_NAME ?? "LEFA",
  description: "LEFA – Universal Payment & Money Management Platform",
  manifest: "/manifest.webmanifest",
  themeColor: "#18181b",
};

export default function RootLayout({ children }: { children: ReactNode }) {
  return (
    <html lang="en">
      <body className="min-h-screen bg-zinc-50 text-zinc-900">
        {children}
        <PwaRegister />
      </body>
    </html>
  );
}
