import { TopNav } from "@/components/nav";
import { Card, CardBody, CardHeader, Container, Button } from "@/components/ui";
import Link from "next/link";
import { requireSession } from "@/lib/session";
import { prisma } from "@/lib/prisma";

export default async function MyDisputes() {
  const session = await requireSession();
  const disputes = await prisma.dispute.findMany({
    where: { userId: session.uid },
    orderBy: { updatedAt: "desc" },
    take: 50,
  });

  return (
    <>
      <TopNav />
      <Container>
        <div className="mx-auto max-w-2xl">
          <Card>
            <CardHeader title="Disputes" subtitle="Your reports" />
            <CardBody>
              <Link href="/app/disputes/new"><Button className="w-full">Report an issue</Button></Link>
              <div className="mt-4 grid gap-2">
                {disputes.length === 0 ? <div className="text-sm text-zinc-600">No disputes yet.</div> : null}
                {disputes.map((d) => (
                  <div key={d.id} className="rounded-xl border border-zinc-200 p-3">
                    <div className="text-sm font-medium">{d.title}</div>
                    <div className="text-xs text-zinc-600">Status: {d.status} • Tx {d.transactionId}</div>
                    <div className="mt-2 text-sm text-zinc-800 whitespace-pre-wrap">{d.description}</div>
                    {d.adminNote ? <div className="mt-2 text-xs text-zinc-600">Admin note: {d.adminNote}</div> : null}
                  </div>
                ))}
              </div>
            </CardBody>
          </Card>
        </div>
      </Container>
    </>
  );
}
