import { NextRequest } from "next/server";
import QRCode from "qrcode";

export async function GET(req: NextRequest) {
  const { searchParams } = new URL(req.url);
  const text = searchParams.get("text") ?? "";
  if (!text) return new Response("Missing text", { status: 400 });

  const svg = await QRCode.toString(text, { type: "svg", margin: 1, width: 256 });
  return new Response(svg, { headers: { "Content-Type": "image/svg+xml" } });
}
