import { prisma } from "@/lib/prisma";
import { requireSession } from "@/lib/session";

export async function GET(req: Request) {
  const session = await requireSession();
  const { searchParams } = new URL(req.url);
  const token = (searchParams.get("token") ?? "").trim();
  if (!token) return Response.json({ error: "MISSING_TOKEN" }, { status: 400 });

  const merchant = await prisma.merchantProfile.findUnique({ where: { userId: session.uid } });
  if (!merchant) return Response.json({ error: "NOT_MERCHANT" }, { status: 403 });

  const charge = await prisma.inStoreCharge.findUnique({ where: { token } });
  if (!charge || charge.merchantId !== merchant.id) return Response.json({ error: "NOT_FOUND" }, { status: 404 });

  return Response.json({ status: charge.status, paidTxId: charge.paidTxId });
}
