import { prisma } from "@/lib/prisma";
import { Card, CardBody, CardHeader } from "@/components/ui";

export default async function AdminHome() {
  const [users, txs, disputesOpen, risk24h] = await Promise.all([
    prisma.user.count(),
    prisma.transaction.count(),
    prisma.dispute.count({ where: { status: "OPEN" } }),
    prisma.riskEvent.count({ where: { createdAt: { gte: new Date(Date.now() - 24 * 60 * 60 * 1000) } } }),
  ]);

  return (
    <div className="grid gap-4 md:grid-cols-4">
      <Card>
        <CardHeader title="Users" subtitle="Total" />
        <CardBody>
          <div className="text-3xl font-semibold">{users}</div>
        </CardBody>
      </Card>
      <Card>
        <CardHeader title="Transactions" subtitle="All time" />
        <CardBody>
          <div className="text-3xl font-semibold">{txs}</div>
        </CardBody>
      </Card>
      <Card>
        <CardHeader title="Open disputes" subtitle="Needs review" />
        <CardBody>
          <div className="text-3xl font-semibold">{disputesOpen}</div>
        </CardBody>
      </Card>
      <Card>
        <CardHeader title="Risk events" subtitle="Last 24h" />
        <CardBody>
          <div className="text-3xl font-semibold">{risk24h}</div>
        </CardBody>
      </Card>
    </div>
  );
}
