import { prisma } from "@/lib/prisma";
import { Card, CardBody, CardHeader, Button } from "@/components/ui";
import { resolveDisputeAction } from "@/app/admin/actions";

export default async function AdminDisputes() {
  const disputes = await prisma.dispute.findMany({
    orderBy: { updatedAt: "desc" },
    take: 50,
    include: {
      user: { select: { email: true } },
    },
  });

  return (
    <Card>
      <CardHeader title="Disputes" subtitle="Latest 50" />
      <CardBody>
        <div className="grid gap-3">
          {disputes.length === 0 ? <div className="text-sm text-zinc-600">No disputes.</div> : null}
          {disputes.map((d) => (
            <div key={d.id} className="rounded-2xl border border-zinc-200 bg-white p-4">
              <div className="flex flex-wrap items-start justify-between gap-3">
                <div>
                  <div className="text-sm font-medium">{d.title}</div>
                  <div className="text-xs text-zinc-600">By {d.user.email} • Tx {d.transactionId}</div>
                  <div className="mt-2 text-sm text-zinc-800 whitespace-pre-wrap">{d.description}</div>
                  <div className="mt-2 text-xs text-zinc-600">Status: <span className="font-medium">{d.status}</span></div>
                  {d.adminNote ? <div className="mt-1 text-xs text-zinc-600">Admin note: {d.adminNote}</div> : null}
                </div>

                <div className="w-full max-w-sm">
                  <form action={resolveDisputeAction} className="grid gap-2">
                    <input type="hidden" name="disputeId" value={d.id} />
                    <select name="action" defaultValue={d.status} className="rounded-xl border border-zinc-200 bg-white px-2 py-2 text-sm">
                      <option value="OPEN">OPEN</option>
                      <option value="IN_REVIEW">IN_REVIEW</option>
                      <option value="RESOLVED">RESOLVED</option>
                      <option value="DISMISSED">DISMISSED</option>
                    </select>
                    <input name="note" placeholder="Admin note (optional)" className="rounded-xl border border-zinc-200 px-3 py-2 text-sm" />
                    <Button type="submit">Update</Button>
                  </form>
                </div>
              </div>
            </div>
          ))}
        </div>
      </CardBody>
    </Card>
  );
}
