# LEFA Platform (MVP Codebase)

This is a production-style MVP scaffold for **LEFA**: a mobile-first, multi-channel payments + money-management platform for Botswana.

The MVP focuses on:
- **LEFA-to-LEFA internal ledger transfers** (instant)
- **Merchant online payments** via Payment Intents + API keys
- **QR payment requests** (short links)
- **Guest checkout (OTP)** for both QR links and merchant checkout links
- **KYC-lite (tiered limits)** + admin approval flow
- **Text-to-Pay** (WhatsApp/SMS style payment links)
- **USSD simulator** (`/ussd`) to demonstrate non-app access
- **Webhooks** for merchants (`payment_intent.succeeded`, `payment_request.paid`)
- **Vendor dashboard** for reconciliation & basic analytics
- **Account linking stubs** (bank/wallet connectors are adapter-based)
- **Lite app (PWA)** installable on Android via "Add to Home Screen"
- **Phone-first sign-in (OTP)** for consumers (email/password still supported for admins)
- **In-store POS QR** (cashier creates charge → customer pays via QR/link)
- **External funding rails (stubs)** for Orange Money / Smega / My Zaka / banks
- **Settlement batches + CSV export** (admin reconciliation stub)

> This codebase implements the core platform pieces described in the LEFA proposal: consolidated accounts, instant payments, QR, dashboards, and APIs for e-commerce integration.

## Stack
- Next.js 14 (App Router)
- NextAuth (Credentials) + Prisma
- PostgreSQL (docker compose)
- Tailwind

## Quickstart

### 1) Requirements
- Node.js 20+
- pnpm 9+
- Docker

### 2) Start Postgres
```bash
pnpm db:up
```

### 3) Configure env
```bash
cp apps/web/.env.example apps/web/.env
```

### 4) Install deps
```bash
pnpm i
```

### 5) Migrate DB + seed
```bash
pnpm --filter @lefa/web prisma:migrate
pnpm --filter @lefa/web db:seed
```

### 6) Run
```bash
pnpm dev
```

Open:
- Web app: http://localhost:3000

## Demo accounts
After seeding:
- consumer: `user@lefa.local` / `password123`
- merchant: `merchant@lefa.local` / `password123`
- admin: `admin@lefa.local` / `password123` (visit `/admin`)
- system: `clearing@lefa.local` / `password123`

Phone-first sign-in is available at `/signin` using OTP (dev OTP displays).

> Guest checkout uses the system/clearing wallet to simulate external rails.
> In production, set `LEFA_CLEARING_USER_ID` to the system user id printed by the seed script.

## Merchant API
- Create API key in **Merchant → API Keys**
- Create a Payment Intent via HTTP:

```bash
curl -X POST http://localhost:3000/api/merchant/payment-intents \
  -H "Authorization: Bearer <API_KEY>" \
  -H "Content-Type: application/json" \
  -d '{"amount":20000,"currency":"BWP","reference":"ORDER-1001","description":"T-shirt order"}'
```

Then share the returned `checkoutUrl` with the customer.

## QR payment requests (short links)
- Go to **QR** in the app.
- Enter amount + reference.
- LEFA creates a short link like `/pay/r/<token>` and generates a QR.
- Share via WhatsApp or print the QR.

### Guest checkout
If a customer opens a QR or checkout link without signing in, they can pay as a guest:
- enter phone
- receive OTP (dev: OTP displays on screen)
- verify + pay

## Webhooks
Merchants can add endpoints in **Merchant → Webhooks**.
LEFA will POST signed JSON events with headers:
- `X-Lefa-Event`
- `X-Lefa-Signature` (HMAC-SHA256 of the JSON body using the webhook secret)

## Notes
- External bank/mobile-money integrations are implemented as **connectors** with a mock provider. Replace `connectors/*` with real partner APIs.
- Settlement batching + CSV export lives at `/admin/settlement` (stub).

## New: In-store POS
- Merchant opens `/merchant/pos`
- Create a location (or use seeded "Main Location")
- Open shift → create a charge → show customer the link `/pay/pos/<token>`
- Customer can pay signed-in (LEFA balance) or as a guest (OTP)

## New: KYC-lite & tiered limits
- Users start at `UNVERIFIED`.
- Verify phone to become `BASIC` (higher limits).
- Submit document number to request `FULL`.
- Admin approves in `/admin/kyc`.

Limits are enforced in the internal ledger (per-tx + daily outgoing).

## New: Text-to-Pay
Create a request at `/app/text-pay`. It generates a link `/t/pay/<token>`.
Customers can pay by signing in, or as a guest (OTP).

## New: USSD simulator
Open `/ussd` and dial `*555#` to run a web-based USSD flow.

